/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.BootROMScreen;
import com.quantumdata.autoupdate.CheckForUpgradeScreen;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.DoneScreen;
import com.quantumdata.autoupdate.DownloadUpgradeScreen;
import com.quantumdata.autoupdate.GetBackupLocationScreen;
import com.quantumdata.autoupdate.GetPCMCIALocationScreen;
import com.quantumdata.autoupdate.IPAddrScreen;
import com.quantumdata.autoupdate.IPGetGenstatsScreen;
import com.quantumdata.autoupdate.IPUpgradeScreen;
import com.quantumdata.autoupdate.IntroScreen2;
import com.quantumdata.autoupdate.IntroductionScreen;
import com.quantumdata.autoupdate.LocalZipFileScreen;
import com.quantumdata.autoupdate.LookFor88XScreen;
import com.quantumdata.autoupdate.PCMCIACardTo88XScreen;
import com.quantumdata.autoupdate.PCMCIACloneCaptureScreen;
import com.quantumdata.autoupdate.PCMCIACloneRestoreScreen;
import com.quantumdata.autoupdate.PCMCIAGenstatsScreen;
import com.quantumdata.autoupdate.PCMCIAUpgradeScreen;
import com.quantumdata.autoupdate.ScreenStack;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class AutoUpdateGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -4454605403542408220L;
    private static final int windowWidth = 640;
    private static final int windowHeight = 480;
    private static final int NO_PREVIOUS_SCREEN = -2;
    private Device88X m_device88X;
    private int m_myScreen;
    private ScreenStack m_screenStack = new ScreenStack();
    private IntroductionScreen m_IntroDialog;
    private IntroScreen2 m_IntroDialog2;
    private IPAddrScreen m_IpAddrDialog;
    private PCMCIAGenstatsScreen m_PcmciaGenstatsDialog;
    private IPGetGenstatsScreen m_Query88XInfoDialog;
    private GetPCMCIALocationScreen m_PcmciaLocationDialog;
    private CheckForUpgradeScreen m_Check4UpgradeDialog;
    private DownloadUpgradeScreen m_DownloadUpgradeDialog;
    private GetBackupLocationScreen m_GetBackupLocationDialog;
    private LookFor88XScreen m_LookFor88XDialog;
    private IPUpgradeScreen m_IpUpgradeDialog;
    private DoneScreen m_doneDialog;
    private PCMCIACardTo88XScreen m_pcmciaCardTo88XDialog;
    private PCMCIACloneCaptureScreen m_pcmciaCloneCaptureDialog;
    private PCMCIAUpgradeScreen m_pcmciaUpgradeScreenDialog;
    private PCMCIACloneRestoreScreen m_pcmciaCloneRestoreDialog;
    private BootROMScreen m_bootRomDialog;
    private LocalZipFileScreen m_getLocalZipFileDialog;

    public AutoUpdateGUI() throws HeadlessException {
        System.out.println("Starting AutoUpdate GUI");
        System.out.println("*** AutoUpdate Version: 1.1.4***");
        this.m_myScreen = 0;
        this.m_device88X = new Device88X();
        this.displayWindow(this.m_myScreen, -2);
    }

    private void configureWindow() {
        Dimension dimension = new Dimension(640, 480);
        this.getContentPane().invalidate();
        this.getContentPane().removeAll();
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setPreferredSize(dimension);
    }

    private boolean displayWindow(int n, int n2) {
        System.out.println("Displaying Screen #" + n);
        this.configureWindow();
        if (n2 != -2 && n != n2) {
            this.m_screenStack.push(n2);
        }
        switch (n) {
            case 0: {
                this.m_IntroDialog = new IntroductionScreen("Upgrade Selection Type", this, this.m_device88X);
                break;
            }
            case 1: {
                this.m_IntroDialog2 = new IntroScreen2("Instructions", this, this.m_device88X);
                break;
            }
            case 2: {
                this.m_IpAddrDialog = new IPAddrScreen("Enter IP Address", this);
                this.m_IpAddrDialog.setIPAddress(this.m_device88X.getIPAddress());
                break;
            }
            case 3: {
                this.m_Query88XInfoDialog = new IPGetGenstatsScreen("Fetching 88X Genstats Info", this);
                this.m_Query88XInfoDialog.run(this.m_device88X);
                break;
            }
            case 4: {
                this.m_PcmciaGenstatsDialog = new PCMCIAGenstatsScreen("Enter Genstats Information", this, this.m_device88X);
                break;
            }
            case 5: {
                this.m_Check4UpgradeDialog = new CheckForUpgradeScreen("Checking for upgrade from the Quantum Data web site", this);
                this.m_Check4UpgradeDialog.run(this.m_device88X);
                break;
            }
            case 6: {
                this.m_DownloadUpgradeDialog = new DownloadUpgradeScreen("Downloading upgrade from the Quantum Data web site", this);
                this.m_DownloadUpgradeDialog.run(this.m_device88X);
                break;
            }
            case 7: {
                this.m_GetBackupLocationDialog = new GetBackupLocationScreen("Define Backup Location", this);
                break;
            }
            case 8: {
                this.m_LookFor88XDialog = new LookFor88XScreen("Checking Again for the 88X Generator", this);
                this.m_LookFor88XDialog.run(this.m_device88X);
                break;
            }
            case 9: {
                this.m_IpUpgradeDialog = new IPUpgradeScreen("Upgrading 88X Generator over Ethernet", this);
                this.m_IpUpgradeDialog.run(this.m_device88X);
                break;
            }
            case 10: {
                this.m_doneDialog = new DoneScreen("Upgrade Complete", this);
                break;
            }
            case 11: {
                this.m_pcmciaCardTo88XDialog = new PCMCIACardTo88XScreen("Insert Card Into 88X", this, 12);
                this.m_pcmciaCardTo88XDialog.setText("<html><body align='center'><p>Please insert a BLANK PCMCIA card into the 88X Generator's PCMCIA card slot.</p><p>Then hit the Next Button Below</p></body></html>");
                break;
            }
            case 12: {
                this.m_pcmciaCloneCaptureDialog = new PCMCIACloneCaptureScreen("Clone Capture", this);
                break;
            }
            case 13: {
                this.m_pcmciaUpgradeScreenDialog = new PCMCIAUpgradeScreen("Copying files to PCMCIA card", this);
                this.m_pcmciaUpgradeScreenDialog.run(this.m_device88X);
                break;
            }
            case 14: {
                this.m_pcmciaCardTo88XDialog = new PCMCIACardTo88XScreen("Insert Card Into 88X To Complete Upgrade", this, 15);
                this.m_pcmciaCardTo88XDialog.setText("<html><body align='center'><p>Please insert PCMCIA card into the 88X Generator's PCMCIA card slot.</p><p>Then hit the Next Button Below</p></body></html>");
                break;
            }
            case 15: {
                this.m_pcmciaCloneRestoreDialog = new PCMCIACloneRestoreScreen("Clone Restore", this);
                break;
            }
            case 16: {
                this.m_bootRomDialog = new BootROMScreen("Boot Rom Upgrade Required", this);
                break;
            }
            case 17: {
                this.m_PcmciaLocationDialog = new GetPCMCIALocationScreen("Set the PCMCIA card Location", this);
                break;
            }
            case 18: {
                this.m_getLocalZipFileDialog = new LocalZipFileScreen("Upgrade From Local ZIP File", this);
                break;
            }
            default: {
                System.out.println("AutoUpdateGUI.displayWindow(): Invalid Screen ID: " + n);
                return false;
            }
        }
        this.pack();
        this.setVisible(true);
        return true;
    }

    public boolean isValidScreen(int n) {
        return n < 19;
    }

    public void FreeData(int n) {
        System.out.println("Freeing Data for Screen #" + n);
        switch (n) {
            case 0: {
                this.m_IntroDialog = null;
                break;
            }
            case 1: {
                this.m_IntroDialog2 = null;
                break;
            }
            case 2: {
                this.m_IpAddrDialog = null;
                break;
            }
            case 3: {
                this.m_Query88XInfoDialog = null;
                break;
            }
            case 4: {
                this.m_PcmciaGenstatsDialog = null;
                break;
            }
            case 5: {
                this.m_Check4UpgradeDialog = null;
                break;
            }
            case 7: {
                this.m_GetBackupLocationDialog = null;
                break;
            }
            case 6: {
                this.m_DownloadUpgradeDialog = null;
                break;
            }
            case 8: {
                this.m_LookFor88XDialog = null;
                break;
            }
            case 9: {
                this.m_IpUpgradeDialog = null;
                break;
            }
            case 10: {
                this.m_doneDialog = null;
                break;
            }
            case 11: {
                this.m_pcmciaCardTo88XDialog = null;
                break;
            }
            case 12: {
                this.m_pcmciaCloneCaptureDialog = null;
                break;
            }
            case 13: {
                this.m_pcmciaUpgradeScreenDialog = null;
                break;
            }
            case 14: {
                this.m_pcmciaCardTo88XDialog = null;
                break;
            }
            case 15: {
                this.m_pcmciaCloneRestoreDialog = null;
                break;
            }
            case 16: {
                this.m_bootRomDialog = null;
                break;
            }
            case 17: {
                this.m_PcmciaLocationDialog = null;
                break;
            }
            case 18: {
                this.m_getLocalZipFileDialog = null;
                break;
            }
            default: {
                System.out.println("AutoUpdateGUI.FreeData(): Invalid Screen ID: " + n);
                return;
            }
        }
        System.gc();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.m_myScreen;
        int n2 = this.m_myScreen;
        System.out.println("\r\n*** Action Event: Screen ID=" + this.m_myScreen);
        switch (this.m_myScreen) {
            case 0: {
                n = this.m_IntroDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 1: {
                n = this.m_IntroDialog2.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 2: {
                n = this.m_IpAddrDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 3: {
                n = this.m_Query88XInfoDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 4: {
                n = this.m_PcmciaGenstatsDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 5: {
                n = this.m_Check4UpgradeDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 6: {
                n = this.m_DownloadUpgradeDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 7: {
                n = this.m_GetBackupLocationDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 8: {
                n = this.m_LookFor88XDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 9: {
                n = this.m_IpUpgradeDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 10: {
                n = this.m_doneDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 11: {
                n = this.m_pcmciaCardTo88XDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 12: {
                n = this.m_pcmciaCloneCaptureDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 13: {
                n = this.m_pcmciaUpgradeScreenDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 14: {
                n = this.m_pcmciaCardTo88XDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 15: {
                n = this.m_pcmciaCloneRestoreDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 16: {
                n = this.m_bootRomDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 17: {
                n = this.m_PcmciaLocationDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            case 18: {
                n = this.m_getLocalZipFileDialog.ScreenHandler(actionEvent, this.m_myScreen, this.m_device88X);
                break;
            }
            default: {
                System.out.println("AutoUpdateGUI.actionPerformed(): Invalid Screen ID: " + this.m_myScreen);
                return;
            }
        }
        if (n != this.m_myScreen) {
            if (n == -1) {
                n = this.m_screenStack.pop();
            }
            if (this.displayWindow(n, n2)) {
                this.m_myScreen = n;
                System.out.println("  - Action Event: New Screen =" + this.m_myScreen);
            } else {
                System.out.println("  - Action Event: Staying in state=" + this.m_myScreen);
                this.displayWindow(this.m_myScreen, n2);
            }
        }
    }
}

